// Persistence Of Vision raytracer version 3.1g isosurface patch with HyperFun
// sample file.
// This image contains an example of 'isosurface'.

#include "colors.inc"

camera {
   up<0,1,0>
   right<-1.33,0,0>
   location <20, 20, 20>
   direction <0, 0,  2.5>
   look_at <0,0,0>
}

light_source {<20, 20,  20> color White}
light_source {<20, 20, -20> color Red}
background {color DarkSlateGray}

isosurface{
     function {"HyperFun", library "hyperfun","HF_program=Sphere.hf, HF_object=sphere, x=1, y=2, z=3", <0,0,0,0>}
     bounded_by{ box {<-8, -8, -8>, <8, 8, 8>}}   
     accuracy 0.01
     sign -1
     eval
     texture {
        pigment {
                color red 1 green 0.75 blue 0.33
        }
        finish {
                diffuse 1
                phong 0
                phong_size 0
                reflection 0
        }
     }

}                                 
